﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Ksiega" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Lista dokumentow nierozliczonych - razem</title>
	<script runat="server">

		public enum Zakres
		{
			Razem, Kontrahenci, Pracownicy, Urzędy
		}

		public class PrnParams : Soneta.Business.ActualContext
		{
			private Zakres zakres = Zakres.Kontrahenci;
			private IPodmiotKasowy odk;
			private IPodmiotKasowy dok;
			private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
			private Waluta waluta;
			private String konto = String.Empty;

			
			public PrnParams(Context context)
				: base(context)
			{
				this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
			}

			[Caption("Stan na dzień")]
			[Priority(1)]
			public override Date Aktualny
			{
				set { base.Aktualny = value; }
				get { return base.Aktualny; }
			}

	
			[Priority(2)]
			public Zakres Zakres
			{
				get { return zakres; }
				set
				{
					zakres = value;
					OnChanged(EventArgs.Empty);
				}
			}

			public RowCondition Condition()
			{
				switch (zakres)
				{
					case Zakres.Kontrahenci:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					case Zakres.Pracownicy:
						return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					case Zakres.Urzędy:
						RowCondition condition = RowCondition.Empty;
						condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
						condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
						return new RowCondition.Not(condition);
					default:
						return RowCondition.Empty;
				}
			}

		
			[Caption("Od kontrahenta")]
			[Priority(3)]
			public IPodmiotKasowy Od
			{
				get { return odk; }
				set
				{
					odk = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Priority(4)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return dok; }
				set
				{
					dok = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(5)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return rodzaj; }
				set
				{
					rodzaj = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Required]
			[Priority(6)]
			public Waluta Waluta
			{
				get { return waluta; }
				set
				{
					waluta = value;
					OnChanged(EventArgs.Empty);
				}
			}


			[Priority(8)]
			public String Konto
			{
				get { return konto; }
				set
				{
					konto = value.ToUpper();
					OnChanged(EventArgs.Empty);
				}
			}
		}

		
		PrnParams pars = null;
		[Soneta.Business.Context(Required = true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}


	    [Context(Required = true)]
	    public WydrukOddzialParams OParams { get; set; }


		private struct CustomerSelection
		{
			private String OdKodu;
			private String DoKodu;

			public void Init(IPodmiotKasowy podmiot1, IPodmiotKasowy podmiot2)
			{
				OdKodu = podmiot1 == null ? null : podmiot1.Kod.ToUpper();
				DoKodu = podmiot2 == null ? null : podmiot2.Kod.ToUpper();

				if (OdKodu != null && DoKodu != null && OdKodu.CompareTo(DoKodu) > 0)
				{
					String tmp = OdKodu; OdKodu = DoKodu; DoKodu = tmp;
				}
			}


			public void EnableFilter(Soneta.Business.View view)
			{
				if (OdKodu != null || DoKodu != null)
					view.FilterCondition += new ConditionHandler(filterProc);
			}


			private void filterProc(object sender, ConditionEventArgs args)
			{
				String pCode = ((RozrachunekIdx)args.Row).Podmiot.Kod.ToUpper();
				args.Accepted &= (OdKodu == null || OdKodu.CompareTo(pCode) <= 0) && (DoKodu == null || pCode.CompareTo(DoKodu) <= 0);
			}


			public String GetTitleString()
			{
				if (OdKodu == null && DoKodu == null)
					return String.Empty;
				else if (OdKodu != null && DoKodu == null)
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "|";
				else if (OdKodu == null && DoKodu != null)
					return "</strong>Do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
				else
					return "</strong>Od kontrahenta: <strong>" + HttpUtility.HtmlEncode(OdKodu) + "</strong>, do kontrahenta: <strong>" + HttpUtility.HtmlEncode(DoKodu) + "|";
			}
		}
		

		Date aktualny;
		private CustomerSelection customerSelection;

		private ZapisRozrachunkuIdx workerZapisu = new ZapisRozrachunkuIdx();
		private String[] kontaArr = null;

		
		class Total
		{

			readonly IPodmiotKasowy podmiot;
			readonly Date aktualny;
			decimal należności;
			decimal zobowiązania;
			decimal nalPrzeterminowane;
			decimal zobPrzeterminowane;
			public Total(IPodmiotKasowy podmiot, Date aktualny)
			{
				this.podmiot = podmiot;
				this.aktualny = aktualny;
			}

			public void Add(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker worker)
			{
				worker.RozrachunekIdx = idx;

				decimal nal = worker.Naleznosc(aktualny).Value;
				decimal zob = worker.Zobowiazanie(aktualny).Value;

				należności += nal;
				zobowiązania += zob;
				if (idx.Termin < aktualny)
				{
					nalPrzeterminowane += nal;
					zobPrzeterminowane += zob;
				}
			}

			public IPodmiotKasowy Podmiot
			{
				get { return podmiot; }
			}
			public decimal Należności
			{
				get { return należności; }
			}
			public decimal Zobowiązania
			{
				get { return zobowiązania; }
			}
			public decimal NalPrzeterminowane
			{
				get { return nalPrzeterminowane; }
			}
			public decimal ZobPrzeterminowane
			{
				get { return zobPrzeterminowane; }
			}
			public decimal Saldo
			{
				get { return należności - zobowiązania; }
			}
		}

		class ComparePodmiot : IComparer
		{
			public int Compare(object x, object y)
			{
				Total px = (Total)x;
				Total py = (Total)y;
				return px.Podmiot.Kod.CompareTo(py.Podmiot.Kod);
			}
		}
		
		
		void OnContextLoad(object sender, EventArgs e)
		{
			aktualny = pars.Aktualny;
			string symbol = pars.Waluta.Symbol.ToUpper();
			customerSelection.Init(pars.Od, pars.Do);

			//
			// -> przygotowanie filtrów kont
			//

			kontaArr = pars.Konto.Trim().Split(new Char[] { ',', ';', '|' }, StringSplitOptions.RemoveEmptyEntries);

			for (int ix = 0; ix < kontaArr.Length; ix++)
				kontaArr[ix] = kontaArr[ix].Trim();
			if (kontaArr.Length == 0 || kontaArr.Length == 1 && kontaArr[0] == String.Empty)
				kontaArr = null;

            ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
			ReportHeader1["CUST"] = customerSelection.GetTitleString();
			ReportHeader1["KONTO"] = String.IsNullOrEmpty(pars.Konto.Trim()) ? "(wszystkie)" : pars.Konto;
			ReportHeader1["WALUTA"] = symbol;

			if (pars.Rodzaj == RodzajDokumentów.Razem)
				ReportHeader1["RODZAJ"] = "";
			else
				ReportHeader1["RODZAJ"] = "</strong>Rodzaj: <strong>" + pars.Rodzaj + "|";

			if (pars.Zakres == Zakres.Razem)
				ReportHeader1["ZAKRES"] = "";
			else
				ReportHeader1["ZAKRES"] = "</strong>Zakres: <strong>" + pars.Zakres + "|";

				KasaModule kasa = KasaModule.GetInstance(dc);
				RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
				Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, aktualny), aktualny);

				view.Condition &= pars.Condition();
            	view.Condition &= OParams.GetConditionIdx();
			
        	RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
					pars.Rodzaj != RodzajDokumentów.Zapłaty,
					pars.Rodzaj != RodzajDokumentów.Zapłaty,
					pars.Rodzaj != RodzajDokumentów.Płatności,
					pars.Rodzaj != RodzajDokumentów.Płatności);
				if (condition != RowCondition.Empty)
					view.Condition &= condition;

				customerSelection.EnableFilter(view);
				view.FilterCondition += new ConditionHandler(KontoFilter);

				StanRozliczeniaRozrachunkuWorker worker = new StanRozliczeniaRozrachunkuWorker();
				worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;

				Hashtable ht = new Hashtable();
				foreach (RozrachunekIdx idx in view)
					if (idx.Kwota.Symbol == symbol)
					{
						Total p = (Total)ht[idx.Podmiot];
						if (p == null)
							ht.Add(idx.Podmiot, p = new Total(idx.Podmiot, aktualny));
						p.Add(idx, worker);
					}

				ArrayList lista = new ArrayList(ht.Values);
				lista.Sort(new ComparePodmiot());
				Grid1.DataSource = lista;
		}


		void KontoFilter(object sender, ConditionEventArgs args)
		{
			if (kontaArr == null)
				return;
			if (!args.Accepted)
				return;

			RozrachunekIdx idx = (RozrachunekIdx)args.Row;
			workerZapisu.RozrachunekIdx = idx;

			foreach (String k in kontaArr)
				if (k != String.Empty && Regex.IsMatch(workerZapisu.Konto, GetFilterExpression(k), RegexOptions.CultureInvariant | RegexOptions.IgnoreCase))
					return;

			args.Accepted = false;
		}

        string GetFilterExpression(string mask)
		{ return '^' + mask.Replace("\\", "\\\\").Replace("?", ".?").Replace("*", ".*").Replace("_", ".?").Replace("%", ".*") + '$'; }

		
		//
		// Zarzadzanie kontekstem
		//


		private WydrukiRozrachunkowSessionProxy sProxy = null;


		private void OnContextLoading(Object sender, EventArgs args)
		{
			sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
			dc.attachContext(sProxy.CloneContext(dc.Context));
		}


		protected override void OnUnload(EventArgs e)
		{
			WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
			base.OnUnload(e);
		}

		
	</script>

</head>
<body>
	<form id="ListaDokumentowNierozliczonychRazem" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" OnContextLoading="OnContextLoading" />
	<cc1:ReportHeader ID="ReportHeader1" Title="Dokumenty nierozliczone - podsumowanie|%ODDZIAL%</strong>Stan na dzień: <strong>{0}|%RODZAJ%%ZAKRES%%CUST%</strong>Waluta: <strong>%WALUTA%</strong>|Konto: <STRONG>%KONTO%" runat="server" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business" DataMember0="Actual"></cc1:ReportHeader>
	
	<ea:Grid ID="Grid1" runat="server" DataMember="Rozrachunki">
		<Columns>
			<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." />
			<ea:GridColumn runat="server" Width="10" DataMember="Podmiot.Kod" Caption="Kontrahent~Kod" EncodeHTML="true" />
			<ea:GridColumn runat="server" DataMember="Podmiot.Nazwa" Total="Info" Caption="Kontrahent~Nazwa" EncodeHTML="true" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Należności" Total="Sum" Caption="Należności~Razem" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="NalPrzeterminowane" Total="Sum" Caption="Należności~Przeter-|minowane" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Zobowiązania" Total="Sum" Caption="Zobowiązania~Razem" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="ZobPrzeterminowane" Total="Sum" Caption="Zobowiązania~Przeter-|minowane" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Saldo" Total="Sum" Caption="Saldo" HideZero="True" Format="{0:n}" />
		</Columns>
	</ea:Grid>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
			<cc1:FooterSubtitle runat="server" Caption="Sporządził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

